Attribute VB_Name = "SAM31"
Option Explicit

'Global constant codes for TellUser routine:
Global Const CLOSE_ERROR = 1
Global Const OPEN_ERROR = 2
Global Const INFO_ERROR = 3
Global Const CANT_ACCESS_SCHEMA_FILE = 4
Global Const ACCESS_DENIED = 5
Global Const DEFAULT_SCHEMA = 6
Global Const INDEX_IS_EMPTY = 7
Global Const BOFERROR = 8
Global Const EOFERROR = 9
Global Const GETERROR = 10
Global Const NULL_PRIMARY_KEY = 11
Global Const CANNOT_READD_SAME_RECORD = 12
Global Const RECORD_ALREADY_EXISTS = 13
Global Const PUTERROR = 14
Global Const SHOULD_ADD_NOT_UPDATE = 15
Global Const MUST_RESTORE_PRIMARY_KEY = 16
Global Const DELETEERROR = 17
Global Const NOTHING_TO_UPDATE = 18
Global Const NOT_A_CSV_FILE = 19
Global Const TOO_MANY_FIELDS = 20
Global Const TYPE_TOO_LARGE = 21
Global Const FIELDPACKERROR = 22
Global Const EXPORT_ABORTED = 23
Global Const NO_SEARCH_TEXT = 24


Global rc As Integer    'Return Code (for function calls)
Global CRLFDelim As String
Global BarDelim As String
Global DatasetRefNum As Integer  'DatasetNumber returned by successful VmxOpen call
Global DatasetAccessMode As Integer
Global SchemaFileName As String
Global SchemaFileNum As Integer
Global SchemaFileAccessibleFlag As Integer
Global SchemaFileContents As String
Global SchemaCommentHeader As String
Global Schema As String
Global SchemaLine As String
Global ThisType As String

Global ExportFileName As String
Global ExportFileNum As Integer

Global SchemaDirtyFlag As Integer
Global SuppressChangeEventFlag As Integer
Global ChangeAlertFlag As Integer
Global ClearOrRestoreToggle As Integer  '0-->clear; 1-->restore

Global DatasetInfo As VBISAMInfo    'See VBIS4016.BAS
Global NumberOfFields As Integer
Global NumberOfDisplayedFields As Integer
Global FieldType(0 To 10) As String
Global FieldNum As Integer
Global CurrentIndex As Integer
Global LastIndexListIndex As Integer

Global PrimaryKey As String     'VBPROD primary key is product name
Global DisplayedPrimaryKey As String
Global SavedPrimaryKey As String
Global Throwaway As String

Type RecordBufferType   'hard-wired for VBPROD dataset
    Description As String
    ProductCategory As String
    FileType As String * 3
    BasePrice As Currency
    PricingNotes As String
    CatalogPage As String * 3
    CompanyName As String
    Phone As String
    Fax As String
    Comments As String
End Type
Global RecordBuffer As RecordBufferType
Global ExportRecBuffer As RecordBufferType

Global Const GREEN = &H8000&
Global Const LIGHT_GREY = &HC0C0C0
Global Const WHITE = &H80000005
Global Const BLUE = &HFFFF00

Global MBType As Integer
Global MBTitle As String
Global Msg As String


' ---------------- From Microsoft VB "CONSTANT.TXT" file:

' Form display
Global Const MODAL = 1

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

' Common Dialog
Global Const DLG_FILE_OPEN = 1
Global Const DLG_FILE_SAVE = 2
Global Const OFN_READONLY = &H1&
Global Const OFN_FILEMUSTEXIST = &H1000&

Sub ExitProgram()

    If DatasetRefNum <> 0 Then rc = VmxClose(DatasetRefNum)
    
    End

End Sub

Sub TellUser(MessageID As Integer)

    MBType = MB_ICONEXCLAMATION

    Select Case MessageID
        Case CLOSE_ERROR
            Msg = "Can't close file; must make emergency exit."
        Case OPEN_ERROR
            Msg = "Could not open dataset C:\VBPROD"
        Case INFO_ERROR
            Msg = "Error getting dataset information; must make emergency exit."
        Case CANT_ACCESS_SCHEMA_FILE
            Msg = "Unable to open schema file (xxxxx.ISS) for read-write."
        Case ACCESS_DENIED
            Msg = "This dataset is currently in use."
        Case DEFAULT_SCHEMA
            MBType = MB_ICONINFORMATION
            Msg = "Initializing new schema file (xxxxx.ISS) to default values."
        Case INDEX_IS_EMPTY
            MBType = MB_ICONINFORMATION
            If CurrentIndex = 0 Then
                Msg = "Dataset is empty (no records)."
            Else
                Msg = "This index is empty."
            End If
        Case BOFERROR
            Msg = "Error in VmxBOF usage."
        Case EOFERROR
            Msg = "Error in VmxEOF usage."
        Case GETERROR
            Msg = "Error in VmxGet usage."
        Case NULL_PRIMARY_KEY
            MBType = MB_ICONINFORMATION
            Msg = "Must have a non-blank primary key to add a record."
        Case CANNOT_READD_SAME_RECORD
            MBType = MB_ICONINFORMATION
            Msg = "Cannot re-add the same record.  Either:" & CRLFDelim & Chr$(10)
            Msg = Msg & "...enter a new primary key to add a new record," & CRLFDelim & Chr$(10)
            Msg = Msg & "or" & CRLFDelim & Chr$(10)
            Msg = Msg & "...click 'Update Record' to change this record's data."
        Case RECORD_ALREADY_EXISTS
            MBType = MB_ICONINFORMATION
            Msg = "This primary key already exists in the file; cannot add this record.  (Primary keys are unique record identifiers.)"
        Case PUTERROR
            Msg = "Error in VmxPut usage."
        Case SHOULD_ADD_NOT_UPDATE
            MBType = MB_ICONINFORMATION
            Msg = "You've changed the primary key; primary keys uniquely identify records.  If you want"
            Msg = Msg & " this NEW record to be ADDED to the file, click 'Add Record' rather than 'Update Record.'"
        Case MUST_RESTORE_PRIMARY_KEY
            MBType = MB_ICONINFORMATION
            Msg = "You've changed the primary key; please restore it, or re-find the original record, before deleting."
        Case DELETEERROR
            Msg = "Error in VmxDelete usage."
        Case NOTHING_TO_UPDATE
            MBType = MB_ICONINFORMATION
            Msg = "You haven't changed any data."
        Case NOT_A_CSV_FILE
            Msg = "File extension for export must be .CSV ('comma-separated values')."
        Case TOO_MANY_FIELDS
            Msg = "This program can manage a maximum of 99 fields; the records in this dataset have more than that.  (Sorry.)"
        Case TYPE_TOO_LARGE
            Msg = "This program cannot process this record format (more than 4096 bytes are required to store its Type structure); sorry."
        Case FIELDPACKERROR
            Msg = "Error in FieldPack function usage."
        Case EXPORT_ABORTED
            MBType = MB_ICONINFORMATION
            Msg = "Export process stopped at your request; .CSV file has been deleted."
        Case NO_SEARCH_TEXT
            Msg = "Please enter your search-key in the text-box above this Seek button." & CRLFDelim & CRLFDelim
            Msg = Msg & "(Will seek to >= your search-key in the current index; see Help.)"
        Case Else
            Msg = "Program error code #" & Str$(MessageID) & "." & Chr$(13) & Chr$(10) & Chr$(10) & "Call for support."
            MBType = MB_ICONSTOP
            MsgBox Msg, MBType, MBTitle
            End '!!! PANIC BAIL-OUT !!!
    End Select

    MsgBox Msg, MBType, MBTitle

End Sub

